/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.api.util.IRidable;
import net.dries007.tfc.network.PacketSimpleMessage;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.objects.potioneffects.PotionEffectsTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EntityMuleTFC
extends EntityMule
implements IAnimalTFC,
ILivestock,
IRidable {
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityMuleTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BIRTHDAY = EntityDataManager.func_187226_a(EntityMuleTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> FAMILIARITY = EntityDataManager.func_187226_a(EntityMuleTFC.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> HALTER = EntityDataManager.func_187226_a(EntityMuleTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private long lastFed;
    private long lastFDecay;
    private long lastDeath;

    public EntityMuleTFC(World world) {
        this(world, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityAnimalTFC.getRandomGrowth(ConfigTFC.Animals.MULE.adulthood, ConfigTFC.Animals.MULE.elder));
    }

    public EntityMuleTFC(World world, IAnimalTFC.Gender gender, int birthDay) {
        super(world);
        this.setGender(gender);
        this.setBirthDay(birthDay);
        this.setFamiliarity(0.0f);
        this.func_70873_a(0);
        this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
    }

    @Override
    public IAnimalTFC.Gender getGender() {
        return IAnimalTFC.Gender.valueOf((Boolean)this.field_70180_af.func_187225_a(GENDER));
    }

    @Override
    public void setGender(IAnimalTFC.Gender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender.toBool());
    }

    @Override
    public int getBirthDay() {
        return (Integer)this.field_70180_af.func_187225_a(BIRTHDAY);
    }

    @Override
    public void setBirthDay(int value) {
        this.field_70180_af.func_187227_b(BIRTHDAY, (Object)value);
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.35f;
    }

    @Override
    public float getFamiliarity() {
        return ((Float)this.field_70180_af.func_187225_a(FAMILIARITY)).floatValue();
    }

    @Override
    public void setFamiliarity(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.field_70180_af.func_187227_b(FAMILIARITY, (Object)Float.valueOf(value));
    }

    @Override
    public boolean isFertilized() {
        return false;
    }

    @Override
    public void setFertilized(boolean value) {
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.MULE.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.MULE.elder;
    }

    @Override
    public boolean isReadyToMate() {
        return false;
    }

    @Override
    public boolean isHungry() {
        return this.lastFed < CalendarTFC.PLAYER_TIME.getTotalDays();
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.MAMMAL;
    }

    @Override
    public TextComponentTranslation getAnimalName() {
        String entityString = EntityList.func_75621_b((Entity)this);
        return new TextComponentTranslation("tfc.animal." + entityString + "." + this.getGender().name().toLowerCase(), new Object[0]);
    }

    @Override
    public boolean isHalter() {
        return (Boolean)this.field_70180_af.func_187225_a(HALTER);
    }

    @Override
    public void setHalter(boolean value) {
        this.field_70180_af.func_187227_b(HALTER, (Object)value);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && BlocksTFC.isGround(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    public void func_70873_a(int age) {
        super.func_70873_a(0);
    }

    public boolean func_70631_g_() {
        return this.getAge() == IAnimalTFC.Age.CHILD;
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getAnimalName().func_150254_d();
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        return ConfigTFC.Animals.MULE.rarity;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.ELDER_AND_POPULATION;
    }

    @Override
    public int getMinGroupSize() {
        return 2;
    }

    @Override
    public int getMaxGroupSize() {
        return 5;
    }

    protected void func_184651_r() {
        EntityAnimalTFC.addCommonLivestockAI(this, 1.2);
        EntityAnimalTFC.addCommonPreyAI((EntityAnimal)this, 1.2);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRunAroundLikeCrazy((AbstractHorse)this, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
    }

    public void func_98054_a(boolean child) {
        double ageScale = 1.0 / (2.0 - this.getPercentToAdulthood());
        this.func_98055_j((float)ageScale);
    }

    protected boolean func_190678_b(EntityPlayer player, ItemStack stack) {
        return false;
    }

    protected void func_110237_h(EntityPlayer player) {
        if (this.isHalter()) {
            super.func_110237_h(player);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 100 == 0) {
            this.func_98054_a(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            float familiarity;
            if (this.func_190695_dh() && this.field_70173_aa % 20 == 0) {
                ItemStack stack;
                int hugeHeavyCount = 0;
                for (int i = 2; !(i >= this.field_110296_bG.func_70302_i_() || CapabilityItemSize.checkItemSize(stack = this.field_110296_bG.func_70301_a(i), Size.HUGE, Weight.VERY_HEAVY) && ++hugeHeavyCount >= 2); ++i) {
                }
                if (hugeHeavyCount >= 2) {
                    this.func_70690_d(new PotionEffect(PotionEffectsTFC.OVERBURDENED, 25, 125, false, false));
                }
            }
            if (this.lastFDecay > -1L && this.lastFDecay + 1L < CalendarTFC.PLAYER_TIME.getTotalDays() && (familiarity = this.getFamiliarity()) < 0.3f) {
                familiarity = (float)((double)familiarity - 0.02 * (double)(CalendarTFC.PLAYER_TIME.getTotalDays() - this.lastFDecay));
                this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
                this.setFamiliarity(familiarity);
            }
            if (this.getAge() == IAnimalTFC.Age.OLD && this.lastDeath < CalendarTFC.PLAYER_TIME.getTotalDays()) {
                this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
                Random random = new Random(this.field_96093_i.getMostSignificantBits() * CalendarTFC.PLAYER_TIME.getTotalDays());
                if (random.nextDouble() < ConfigTFC.Animals.MULE.oldDeathChance) {
                    this.func_70106_y();
                }
            }
        }
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable other) {
        if (other == this) {
            EntityMuleTFC baby = new EntityMuleTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
            this.func_190681_a((EntityAgeable)this, (AbstractHorse)baby);
            return baby;
        }
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_MULE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GENDER, (Object)true);
        this.func_184212_Q().func_187214_a(BIRTHDAY, (Object)0);
        this.func_184212_Q().func_187214_a(FAMILIARITY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(HALTER, (Object)false);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110207_m(false);
        }
        super.func_70645_a(cause);
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("gender", this.getGender().toBool());
        nbt.func_74768_a("birth", this.getBirthDay());
        nbt.func_74772_a("fed", this.lastFed);
        nbt.func_74772_a("decay", this.lastFDecay);
        nbt.func_74776_a("familiarity", this.getFamiliarity());
        nbt.func_74772_a("lastDeath", this.lastDeath);
        nbt.func_74757_a("halter", this.isHalter());
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGender(IAnimalTFC.Gender.valueOf(nbt.func_74767_n("gender")));
        this.setBirthDay(nbt.func_74762_e("birth"));
        this.lastFed = nbt.func_74763_f("fed");
        this.lastFDecay = nbt.func_74763_f("decay");
        this.setFamiliarity(nbt.func_74760_g("familiarity"));
        this.lastDeath = nbt.func_74763_f("lastDeath");
        this.setHalter(nbt.func_74767_n("halter"));
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            boolean holdingChest = false;
            if (stack.func_77973_b() instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                holdingChest = itemBlock.func_179223_d() instanceof BlockChest;
            }
            if (stack.func_77973_b() == Items.field_151063_bx) {
                return super.func_184645_a(player, hand);
            }
            if (!this.func_190695_dh() && this.func_110248_bS() && holdingChest) {
                this.func_110207_m(true);
                this.func_190697_dk();
                this.func_110226_cD();
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
            if (this.canAcceptHalter(stack)) {
                return this.attemptApplyHalter((EntityAnimal)this, this.field_70170_p, player, stack);
            }
            if (this.isFood(stack) && player.func_70093_af() && this.getAdultFamiliarityCap() > 0.0f) {
                if (this.isHungry()) {
                    IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
                    if (cap != null && cap.isRotten()) {
                        return false;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.lastFDecay = this.lastFed = CalendarTFC.PLAYER_TIME.getTotalDays();
                        this.func_175505_a(player, stack);
                        if (this.getAge() == IAnimalTFC.Age.CHILD || this.getFamiliarity() < this.getAdultFamiliarityCap()) {
                            float familiarity = this.getFamiliarity() + 0.06f;
                            if (this.getAge() != IAnimalTFC.Age.CHILD) {
                                familiarity = Math.min(familiarity, this.getAdultFamiliarityCap());
                            }
                            this.setFamiliarity(familiarity);
                        }
                        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.AMBIENT, 1.0f, 1.0f);
                        TFCTriggers.FAMILIARIZATION_TRIGGER.trigger((EntityPlayerMP)player, this);
                    }
                    return true;
                }
                if (!this.field_70170_p.field_72995_K && this.isFertilized() && this.getType() == IAnimalTFC.Type.MAMMAL) {
                    TerraFirmaCraft.getNetwork().sendTo((IMessage)PacketSimpleMessage.translateMessage(PacketSimpleMessage.MessageCategory.ANIMAL, "tfc.tooltip.animal.mating.pregnant", this.getAnimalName()), (EntityPlayerMP)player);
                }
            }
        }
        return super.func_184645_a(player, hand);
    }
}

